import UIKit

class ViewController: UIViewController
{
    @IBOutlet weak var resLabel: UILabel!
    @IBOutlet weak var drawView: UIView!
    @IBOutlet weak var startLabel: UILabel!
    @IBOutlet weak var endLabel: UILabel!
    
    var mySimpleGesture : MyCustomGesture!
    var pointOne: CGPoint!
    var pointTwo: CGPoint!
    
    @IBAction func redrawAction(_ sender: Any)
    {
        var ranX = CGFloat(arc4random_uniform(UInt32(drawView.frame.size.width)))
        var ranY = CGFloat(arc4random_uniform(UInt32(drawView.frame.size.height)))
        pointOne = CGPoint (x: ranX, y: ranY)
        startLabel.center = pointOne
        
        ranX = CGFloat(arc4random_uniform(UInt32(drawView.frame.size.width)))
        ranY = CGFloat(arc4random_uniform(UInt32(drawView.frame.size.height)))
        pointTwo = CGPoint (x: ranX, y: ranY)
        endLabel.center = pointTwo
    }
    

    override func viewDidLoad()
    {
        super.viewDidLoad()
        
        redrawAction(self)
        
        mySimpleGesture = MyCustomGesture (target: self,
                                           action: #selector (gestAction))
        drawView.addGestureRecognizer(mySimpleGesture)
    }
    
    
    
    
    
    
    
    @objc func gestAction ()
    {
        let curAngle = atan2(pointTwo.y - pointOne.y, pointTwo.x - pointOne.x)
        let tolerance : CGFloat = 0.2
        
        if ( mySimpleGesture.state == UIGestureRecognizer.State.ended )
        {
            let angleDiff = abs (mySimpleGesture.angle - curAngle)
        
            if ( angleDiff < tolerance )
            {
                resLabel.text = "YOU FOUND THE DIRECTION"
                resLabel.backgroundColor = UIColor.green
            }
            else
            {
                resLabel.text = "TRY AGAIN"
                resLabel.backgroundColor = UIColor.red
            }
        
        }
        // compare
    }
}


class MyCustomGesture: UIGestureRecognizer
{
    var angle: CGFloat = 0.0
    var startingPoint: CGPoint!
    var endingPoint: CGPoint!
    var tempGuides: Array <UIView> = []
    
    override func touchesBegan(_ touches: Set<UITouch>,
                               with event: UIEvent)
    {
        state = UIGestureRecognizer.State.began
        startingPoint = touches.first?.location(in: view)
        angle = 0.0
    }
    
    override func touchesMoved(_ touches: Set<UITouch>,
                               with event: UIEvent)
    {
        let guide = UIView(frame: CGRect(x: 0, y: 0, width: 5, height: 5))
        guide.backgroundColor = UIColor.red
        guide.center = (touches.first?.location(in: view))!
        view?.addSubview(guide)
        tempGuides.append(guide)
    }
    
    override func touchesEnded(_ touches: Set<UITouch>,
                               with event: UIEvent)
    {
        for any in tempGuides {
            any.removeFromSuperview()
        }
        tempGuides = []
            
        state = UIGestureRecognizer.State.ended
        endingPoint = touches.first?.location(in: view)
        
        angle = atan2(endingPoint.y - startingPoint.y,
                      endingPoint.x - startingPoint.x)
    }
    
}
